class Loader extends Phaser.Scene {
    constructor() {
        super("bootGame");
    }

    preload() {
        const width = this.cameras.main.width;
        const height = this.cameras.main.height;

        // Cuadro de fondo (opcional)
        const progressBox = this.add.graphics();
        progressBox.lineStyle(4, 0xFF0000, 1); // borde rojo
        progressBox.strokeRect(width / 2 - 150, height / 2 - 15, 300, 30); // marco

        // Barra de progreso (blanca)
        const progressBar = this.add.graphics();

        // Texto de carga
        const loadingText = this.make.text({
            x: width / 2,
            y: height / 2 - 50,
            text: 'Espere por favor...',
            style: {
                font: '20px monospace',
                fill: '#ffffff'
            }
        }).setOrigin(0.5);

        const percentText = this.make.text({
            x: width / 2,
            y: height / 2 + 45,
            text: '0%',
            style: {
                font: '18px monospace',
                fill: '#ffffff'
            }
        }).setOrigin(0.5);

        const assetText = this.make.text({
            x: width / 2,
            y: height / 2 + 80,
            text: '',
            style: {
                font: '18px monospace',
                fill: '#ff6600'
            }
        }).setOrigin(0.5);

        // Eventos de carga
        this.load.on('progress', function (value) {
            percentText.setText(parseInt(value * 100) + '%');
            progressBar.clear();
            progressBar.fillStyle(0xffffff, 1); // blanco
            progressBar.fillRect(width / 2 - 148, height / 2 - 13, 296 * value, 26); // interior
        });

        this.load.on('fileprogress', function (file) {
            assetText.setText('Cargando: ' + file.key);
        });

        this.load.on('complete', function () {
            progressBar.destroy();
            progressBox.destroy();
            loadingText.destroy();
            percentText.destroy();
            assetText.destroy();
        });

        // Assets
        this.load.json('questions', 'questions.json');
        for (let i = 0; i < 19; i++) {
            this.load.image('questionImage_' + i, "Assets/img/dp/" + i + ".png");
        }
        this.load.image("questionImageBackground", "Assets/img/dp/qbg.png");
        this.load.image("startButton", "Assets/img/comenzarb.png");
        this.load.image("playButton", "Assets/img/comenzarb.png");
        this.load.image("endButton", "Assets/img/terminarb.png");
        this.load.css('JohnsonDisplay-Medium', 'Assets/fonts/JohnsonDisplay-Medium.otf');
        this.load.audio("buttonSnd", "Assets/snd/StartGameMelody.wav");
        this.load.audio("looseSnd", "Assets/snd/DescendingMusicalPhraseQuirkyBrassBellsandWoodwinds.wav");
        this.load.audio("scoreSnd", "Assets/snd/AscendingAchievementPlayful.wav");
        this.load.audio("endSnd", "Assets/snd/LevelUpBrightChimes.wav");
        this.load.audio("musicSnd", "Assets/snd/music.mp3");
        this.load.image("backgroundIdle", "Assets/img/1.png");
        this.load.image("backgroundInstructions", "Assets/img/2.png");
        this.load.image("backgroundTrivia", "Assets/img/3b.png");
        this.load.image("backgroundEnd", "Assets/img/4.png");
        this.load.image("idle", "Assets/img/answerb.png");
        this.load.image("correct", "Assets/img/okb.png");
        this.load.image("wrong", "Assets/img/badb.png");
    }

    create() {
        this.changeScene();
    }

    changeScene() {
        this.scene.start('idle');
    }
}
